<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vesting extends Model 
{

    protected $table = 'vestings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('employee_id', 'start_period', 'date_limit', 'vacations_option_id', 'vacations_enjoyed', '13th_advance', 'justification');

    public function vacation()
    {
        return $this->hasOne('App\Models\Vacation');
    }

    public function vacation_option()
    {
        return $this->hasOne('App\Models\Vacations_option');
    }

}